/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.content.contraption.components.actor;

import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.satisfy.nethervinery.core.registry.NetherObjectRegistry;
import net.satisfy.vinery.core.block.GrapeBush;
import net.satisfy.vinery.core.block.GrapeVineBlock;
import net.satisfy.vinery.core.block.StemBlock;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import plus.dragons.createcentralkitchen.content.contraptions.components.actor.HarvesterMovementBehaviourExtension;

@Mod.EventBusSubscriber(modid="createdelightcore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VineryHarvesterMovementBehaviorExtensions {
    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.RED_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.WHITE_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.TAIGA_RED_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.TAIGA_WHITE_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.SAVANNA_RED_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.SAVANNA_WHITE_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NetherObjectRegistry.CRIMSON_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NetherObjectRegistry.WARPED_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeBush);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.JUNGLE_RED_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeVine);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.JUNGLE_WHITE_GRAPE_BUSH.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeVine);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)ObjectRegistry.GRAPEVINE_STEM.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeStem);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NetherObjectRegistry.OBSIDIAN_STEM.get(), VineryHarvesterMovementBehaviorExtensions::harvestGrapeStem);
        });
    }

    public static void harvestGrapeBush(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        Block block = state.m_60734_();
        if (!(block instanceof GrapeBush)) {
            return;
        }
        GrapeBush bush = (GrapeBush)block;
        int age = (Integer)state.m_61143_((Property)GrapeBush.AGE);
        if (age <= 0) {
            return;
        }
        if (!partial && age < 3) {
            return;
        }
        Level level = context.world;
        if (replant) {
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)GrapeBush.AGE, (Comparable)Integer.valueOf(1)), 2);
        } else {
            BlockHelper.destroyBlock((Level)level, (BlockPos)pos, (float)1.0f, $ -> {});
        }
        behaviour.dropItem(context, new ItemStack((ItemLike)bush.type.getFruit(), level.f_46441_.m_188503_(2) + 1));
    }

    public static void harvestGrapeVine(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        Block block = state.m_60734_();
        if (!(block instanceof GrapeVineBlock)) {
            return;
        }
        GrapeVineBlock vineBlock = (GrapeVineBlock)block;
        int age = (Integer)state.m_61143_((Property)GrapeBush.AGE);
        if (age <= 0) {
            return;
        }
        if (!partial && age < 3) {
            return;
        }
        Level level = context.world;
        if (replant) {
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)GrapeVineBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
        } else {
            BlockHelper.destroyBlock((Level)level, (BlockPos)pos, (float)1.0f, $ -> {});
        }
        behaviour.dropItem(context, new ItemStack((ItemLike)vineBlock.type.getFruit(), level.f_46441_.m_188503_(2) + 1));
    }

    public static void harvestGrapeStem(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        Block block = state.m_60734_();
        if (!(block instanceof StemBlock)) {
            return;
        }
        StemBlock stemBlock = (StemBlock)block;
        stemBlock.isMature(state);
        int age = (Integer)state.m_61143_((Property)StemBlock.AGE);
        if (age <= 0) {
            return;
        }
        if (!partial && age < 4) {
            return;
        }
        Level level = context.world;
        int x = 1 + level.f_46441_.m_188503_(stemBlock.isMature(state) ? 2 : 1);
        int bonus = stemBlock.isMature(state) ? 2 : 1;
        behaviour.dropItem(context, new ItemStack((ItemLike)((GrapeType)state.m_61143_((Property)StemBlock.GRAPE)).getFruit(), x + bonus));
        if (replant) {
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)StemBlock.AGE, (Comparable)Integer.valueOf(2)), 2);
        } else {
            behaviour.dropItem(context, new ItemStack((ItemLike)((GrapeType)state.m_61143_((Property)StemBlock.GRAPE)).getSeeds(), 1));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)StemBlock.GRAPE, (Comparable)GrapeTypeRegistry.NONE), 2);
        }
    }
}

